<?php

class CasherApi
{
    public const BitcoinToQiwi       = 1; //Биткоин на Qiwi
    public const BitcoinToCardsRU       = 2; //Биткоин на карты РФ
    public const LitecoinToQiwi		 = 6; //Лайт на Киви
    public const LitecoinToCardsRU      = 7; //Лайт на Любые банки РФ
    public const UsdtTRC20ToCardsRU   = 11; //USDT TRC-20 на Любые банки РФ
    public const UsdtTRC20ToQiwi     = 12; // USDT TRC-20 на Qiwi
    public const MoneroToQiwi   = 16; //Монеро на Киви
    public const MoneroToCardsRU     = 17; //Монеро на карты РФ
    public const QiwiToBitcoin = 24; //Киви на биткоин
    public const QiwiToLitecoin  = 25; //Киви на лайт
    public const QiwiToUsdtTRC20    = 26; //Киви на USDT TRC20
    public const QiwiToMonero     = 27;  // Киви на Монеро
    public const CardsRUToBitcoin = 28; //Карты РФ на биткоин
    public const CardsRUToLitecoin      = 29; // Карты РФ на Лайт
    public const CardsRUToUsdtTRC20    = 30; //Карты РФ на USDT TRC20
    public const CardsRUToMonero    = 31; //Карты РФ на Монеро
    public const BitcoinToTinkoffCash        = 41; //Биткоин на Тиньков КЕШ ИН
    public const BitcoinToAlfaBankCash    = 42; //Биткоин на  Альфабанк КЕШ ИН
    public const BitcoinToSberbank    = 43; // Биткоин на Сбербанк
    public const BitcoinToTinkoff   = 44; // Биткоин на  Тинькофф
    public const BitcoinToBankKZT   = 46; //Биткоин на Любой банк КАЗАХСТАНА
    public const BitcoinToBankKZT   = 46; //Биткоин на Любой банк КАЗАХСТАНА
    public const UsdtTRC20ToBitcoin = 47; //UsdtTRC20 на Биткоин
    public const BitcoinToUsdtTRC20 = 49; //Биткоин на UsdtTRC20

    protected $baseUrl = 'https://casher.su/api/';

    protected $secret;

    public function __construct($secret)
    {
        $this->secret = $secret;
    }

    public function getStatus()
    {
        return $this->request('GET', 'status');
    }

    public function getMe()
    {
        return $this->request('GET', 'me');
    }

    public function getCurrencies()
    {
        return $this->request('GET', 'currencies');
    }

    public function getDirections()
    {
        return $this->request('GET', 'directions');
    }

    public function convert($directionId)
    {
        return $this->request('GET', 'convert/'. $directionId);
    }

    public function getOrder($orderId, $secret)
    {
        return $this->request('GET', 'order/'. $orderId .'/'. $secret);
    }

    public function cancelOrder($orderId, $secret)
    {
        return $this->request('DELETE', 'order/'. $orderId .'/'. $secret);
    }

    public function createOrder($directionId, $params)
    {
        return $this->request('POST', 'order/'. $directionId .'/create', $params);
    }

    protected function request($method, $url, array $params = [])
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Casher API Client');
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30);
        curl_setopt($ch, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Accept: application/json',
            'Api-Secret: '. $this->secret,
        ]);

        if ($method == 'GET') {
            curl_setopt($ch, CURLOPT_URL, $this->baseUrl . $url .'?'. http_build_query($params));
            curl_setopt($ch, CURLOPT_HTTPGET, true);
        } else {
            curl_setopt($ch, CURLOPT_URL, $this->baseUrl . $url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        }

        $output = curl_exec($ch);
        $code   = (int) curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error  = curl_error($ch);

        curl_close($ch);

        if ($output) {
            $output = json_decode($output, true);

            if (json_last_error() === JSON_ERROR_NONE) {
                return new CasherApiResponse($output, $code);
            }
        }

        if ($error) {
            throw new Exception($error);
        } else {
            throw new Exception('Unknown error.');
        }
    }
}

class CasherApiResponse
{
    protected $output;
    protected $code;

    public function __construct($output, $code)
    {
        $this->output = $output;
        $this->code   = $code;
    }

    public function isOk()
    {
        return $this->code == 200;
    }

    public function isFail()
    {
        return $this->code != 200;
    }

    public function get()
    {
        return $this->output;
    }
}
